/*
 The Techlabs Pure MVC Tutorial
 Copyright (c) 2009 Pedro Furtado (pedro.furtado@gmail.com)
 Your reuse is governed by the Creative Commons Attribution 3.0 License
*/
package com.techlabs.puremvc.model
{
	import com.techlabs.puremvc.ApplicationFacade;
	import com.techlabs.puremvc.model.business.LoadXMLDelegate;
	import com.techlabs.puremvc.model.helpers.XmlResource;
	
	import flash.net.SharedObject;
	
	import mx.rpc.IResponder;
	
	import org.puremvc.as3.interfaces.*;
	import org.puremvc.as3.patterns.proxy.Proxy;
	
    /**
     * A proxy for read the config file
     */
    public class ConfigProxy extends Proxy implements IProxy, IResponder
    {
		public static const NAME:String = "ConfigProxy";

		private var sharedObject:SharedObject;
		public var mySoData:Object;

		public function ConfigProxy ( data:Object = null ) 
        {
            super ( NAME, data );
			
        }
		
		public function load():void
		{
			// reset the data 
			this.data = new Object();
			// create a worker who will go get some data
			// pass it a reference to this proxy so the delegate knows where to return the data
			var delegate : LoadXMLDelegate = new LoadXMLDelegate(this, 'assets/config.xml');
			// make the delegate do some work
			delegate.load();
			
			try{
				sharedObject = SharedObject.getLocal('rssReader');
				mySoData = sharedObject.data
			}catch(err:Error){
				this.sendNotification(ApplicationFacade.ERROR_LOAD_FILE, err.message)
			}
		}
		
		// this is called when the delegate receives a result from the service
		public function result( rpcEvent : Object ) : void
		{
			// call the helper class for parse the XML data
			XmlResource.parse(data, rpcEvent.result);
		}
		
		// this is called when the delegate receives a fault from the service
		public function fault( rpcEvent : Object ) : void 
		{
			// send the failed notification
			this.sendNotification( ApplicationFacade.LOAD_CONFIG_FAILED, ApplicationFacade.ERROR_LOAD_FILE );
		}
		
		/**
         * Get the config value
		 * 
         * @param key the key to read 
         * @return String the key value stored in internal object
         */
		public function getValue(key:String):String
		{
			return data[key.toLowerCase()];
		}


		
	}
}